/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.commands.parsers;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.commands.CommandSource;
import net.impactdev.impactor.api.platform.players.PlatformPlayer;
import net.impactdev.impactor.api.platform.players.PlatformPlayerService;
import net.impactdev.impactor.api.platform.sources.PlatformSource;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import org.incendo.cloud.suggestion.Suggestion;

public final class PlatformSourceParser
implements ArgumentParser<CommandSource, PlatformSource>,
BlockingSuggestionProvider<CommandSource> {
    private static final Pattern SELECTOR = Pattern.compile("@[rs]");
    private final PlainTextComponentSerializer plain = PlainTextComponentSerializer.plainText();

    public @NonNull ArgumentParseResult<@NonNull PlatformSource> parse(@NonNull CommandContext<@NonNull CommandSource> context, @NonNull CommandInput args2) {
        Optional<PlatformSource> target;
        PlatformPlayerService service = Impactor.instance().services().provide(PlatformPlayerService.class);
        Set<PlatformPlayer> online = service.online();
        HashSet<PlatformSource> options = new HashSet<PlatformSource>();
        options.add(PlatformSource.server());
        options.addAll(online);
        String input = args2.peekString();
        Matcher selector = SELECTOR.matcher(input);
        if (selector.matches()) {
            try {
                target = Optional.of(this.parseFromSelector(context, input));
            }
            catch (IllegalArgumentException e) {
                return ArgumentParseResult.failure((Throwable)e);
            }
        } else {
            target = options.stream().filter(player -> this.plain.serialize(player.name()).equalsIgnoreCase(args2.peekString())).findFirst();
        }
        return target.map(player -> {
            args2.readString();
            return player;
        }).map(ArgumentParseResult::success).orElseGet(() -> ArgumentParseResult.failure((Throwable)new IllegalArgumentException("No match for username found...")));
    }

    public @NonNull Iterable<@NonNull Suggestion> suggestions(@NonNull CommandContext<CommandSource> context, @NonNull CommandInput input) {
        PlatformPlayerService service = Impactor.instance().services().provide(PlatformPlayerService.class);
        List names = service.online().stream().map(player -> this.plain.serialize(player.name())).collect(Collectors.toList());
        names.add("Server");
        names.add("@r");
        names.add("@s");
        return names.stream().filter(name -> name.toLowerCase().startsWith(input.peekString().toLowerCase())).map(Suggestion::suggestion).collect(Collectors.toList());
    }

    private PlatformSource parseFromSelector(CommandContext<CommandSource> context, String input) {
        String selector = input.substring(1);
        return switch (selector.toLowerCase()) {
            case "s" -> ((CommandSource)context.sender()).source();
            case "r" -> {
                Random rng = new Random();
                List players = Impactor.instance().services().provide(PlatformPlayerService.class).online().stream().toList();
                yield (PlatformPlayer)players.get(rng.nextInt(players.size()));
            }
            default -> throw new IllegalArgumentException("Invalid selector: " + selector);
        };
    }
}

